<?php 
require_once 'inc/db.php'; 
require_once 'inc/functions.php'; 

// Site Ayarlarını Çek (Logo ve Başlık için)
$settings = $db->query("SELECT * FROM settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);

// .htaccess sayesinde gelen slug verisini alıyoruz
$slug = isset($_GET['slug']) ? secure($_GET['slug']) : '';

// Yazıyı, kategorisiyle birlikte slug üzerinden çek
$sorgu = $db->prepare("SELECT posts.*, categories.name AS cat_name 
                       FROM posts 
                       LEFT JOIN categories ON posts.category_id = categories.id 
                       WHERE posts.slug = ? AND status = 'published'");
$sorgu->execute([$slug]);
$yazi = $sorgu->fetch(PDO::FETCH_ASSOC);

// Yazı yoksa ana sayfaya şutla
if (!$yazi) { header("Location: index.php"); exit; }

// Dinamik okuma süresini hesapla (functions.php'deki fonksiyonunla)
$dakika = okumaSuresi($yazi['content']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($yazi['title']); ?> | <?php echo $settings['site_title']; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Plus Jakarta Sans', sans-serif; background-color: #fff; scroll-behavior: smooth; }
        .glass { background: rgba(255, 255, 255, 0.85); backdrop-filter: blur(12px); }
        /* Makale içi metinlerin okunabilirliği için özel ayar */
        .article-content p { margin-bottom: 1.8rem; line-height: 1.9; color: #334155; font-size: 1.15rem; }
    </style>
</head>
<body class="text-slate-900 selection:bg-black selection:text-white">

    <nav class="glass border-b border-slate-100 sticky top-0 z-50">
        <div class="max-w-5xl mx-auto px-6">
            <div class="flex flex-col md:flex-row md:h-20 py-4 md:py-0 justify-between items-center gap-4">
                <a href="index.php" class="flex items-center shrink-0">
                    <?php if(!empty($settings['site_logo'])): ?>
                        <img src="assets/<?php echo $settings['site_logo']; ?>" class="h-7 w-auto">
                    <?php else: ?>
                        <span class="text-2xl font-black tracking-tighter uppercase italic">BLOG<span class="text-indigo-600">.</span>PRO</span>
                    <?php endif; ?>
                </a>

                <div class="w-full md:w-80 order-3 md:order-2">
                    <form action="arama.php" method="GET" class="relative group">
                        <input type="text" name="q" placeholder="Hızlı ara..." 
                               class="w-full bg-slate-100 border-none rounded-2xl px-5 py-2.5 text-xs font-bold outline-none focus:ring-2 focus:ring-black transition-all">
                    </form>
                </div>

                <div class="order-2 md:order-3">
                    <a href="index.php" class="text-[10px] font-black uppercase tracking-widest text-slate-400 hover:text-black transition">← GERİ DÖN</a>
                </div>
            </div>
        </div>
    </nav>

    <article class="max-w-4xl mx-auto px-6 py-16">
        <header class="text-center mb-16">
            <div class="flex items-center justify-center gap-3 mb-8">
                <a href="kategori.php?id=<?php echo $yazi['category_id']; ?>" class="px-4 py-1.5 bg-black text-white text-[9px] font-black uppercase tracking-widest rounded-xl shadow-lg">
                    <?php echo $yazi['cat_name']; ?>
                </a>
                <span class="text-slate-300">—</span>
                <span class="text-slate-400 text-[9px] font-black uppercase tracking-widest"><?php echo $dakika; ?> DK OKUMA</span>
            </div>

            <h1 class="text-4xl md:text-7xl font-extrabold tracking-tighter leading-none mb-10 italic">
                <?php echo htmlspecialchars($yazi['title']); ?>
            </h1>

            <div class="flex items-center justify-center gap-4 text-slate-400 text-[11px] font-bold uppercase tracking-widest">
                <time><?php echo timeTR($yazi['created_at']); ?></time>
            </div>
        </header>

        <?php if(!empty($yazi['thumbnail'])): ?>
        <div class="mb-20 rounded-[3.5rem] overflow-hidden shadow-2xl shadow-indigo-100/50">
            <img src="uploads/<?php echo $yazi['thumbnail']; ?>" alt="<?php echo $yazi['title']; ?>" class="w-full h-auto">
        </div>
        <?php endif; ?>

        <div class="article-content max-w-3xl mx-auto">
            <div class="prose prose-slate prose-lg max-w-none italic">
                <?php echo nl2br($yazi['content']); ?>
            </div>
        </div>

        <footer class="max-w-3xl mx-auto mt-24 pt-12 border-t border-slate-100">
            <div class="flex flex-col md:flex-row justify-between items-center gap-8">
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 rounded-full bg-slate-100 border border-slate-200"></div>
                    <div>
                        <p class="text-[10px] font-black text-slate-300 uppercase tracking-widest">Yazar</p>
                        <p class="text-sm font-bold uppercase italic">Editör</p>
                    </div>
                </div>
                
                <div class="flex gap-4">
                    <a href="kategori.php" class="px-8 py-4 bg-black text-white text-[10px] font-black uppercase tracking-widest rounded-2xl hover:bg-indigo-600 transition-all shadow-xl">
                        Tüm Yazıları Gör
                    </a>
                </div>
            </div>
        </footer>
    </article>

    <footer class="py-20 text-center text-slate-400 text-[10px] font-black uppercase tracking-[0.5em]">
        © <?php echo date('Y'); ?> <?php echo $settings['site_footer']; ?>
    </footer>

</body>
</html>