<?php 
require_once 'inc/db.php'; 
require_once 'inc/functions.php';

$settings = $db->query("SELECT * FROM settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
$q = isset($_GET['q']) ? secure($_GET['q']) : '';

if (!empty($q)) {
    $sorgu = $db->prepare("SELECT posts.*, categories.name as cat_name FROM posts 
                           LEFT JOIN categories ON posts.category_id = categories.id 
                           WHERE (posts.title LIKE ? OR posts.content LIKE ?) AND status = 'published' 
                           ORDER BY posts.id DESC");
    $sorgu->execute(["%$q%", "%$q%"]);
    $results = $sorgu->fetchAll(PDO::FETCH_ASSOC);
} else {
    $results = [];
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Arama: <?php echo htmlspecialchars($q); ?> | <?php echo $settings['site_title']; ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>body { font-family: 'Plus Jakarta Sans', sans-serif; }</style>
</head>
<body class="bg-white text-slate-900">

    <?php include 'inc/nav.php'; ?>

    <main class="max-w-7xl mx-auto px-6 py-20">
        <div class="mb-16">
            <h2 class="text-4xl font-black tracking-tighter uppercase italic">Sonuçlar<span class="text-indigo-600">.</span></h2>
            <p class="text-slate-400 mt-2 font-medium">"<?php echo htmlspecialchars($q); ?>" araması için <b><?php echo count($results); ?></b> içerik listeleniyor.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-12">
            <?php if(count($results) > 0): foreach($results as $art): ?>
            <article class="group">
                <a href="<?php echo $art['slug']; ?>">
                    <div class="relative aspect-video rounded-[2.5rem] overflow-hidden bg-slate-50 mb-6 border border-slate-100 shadow-sm group-hover:shadow-xl transition-all">
                        <img src="uploads/<?php echo $art['thumbnail']; ?>" class="w-full h-full object-cover grayscale group-hover:grayscale-0 transition-all duration-700">
                    </div>
                    <h3 class="text-2xl font-bold leading-tight group-hover:text-indigo-600 transition-colors"><?php echo $art['title']; ?></h3>
                </a>
            </article>
            <?php endforeach; else: ?>
                <div class="col-span-full py-32 text-center bg-slate-50 rounded-[3rem]">
                    <p class="text-slate-400 font-black uppercase tracking-widest italic">Aradığınız kriterlere uygun yazı bulunamadı.</p>
                    <a href="index.php" class="inline-block mt-6 text-xs font-bold text-indigo-600 underline">Anasayfaya Dön</a>
                </div>
            <?php endif; ?>
        </div>
    </main>

</body>
</html>