<?php
// Hangi sayfada olduğumuzu anlamak için dosya adını alıyoruz
$current_page = basename($_SERVER['PHP_SELF']);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Burak Kılıç</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #FBFBFB; }
        
        /* Aktif sayfa linki için alt çizgi efekti */
        .nav-link { position: relative; transition: color 0.3s ease; }
        .active-link { color: #000 !important; font-weight: 600; }
        .active-link::after {
            content: '';
            position: absolute;
            bottom: -5px;
            left: 0;
            width: 12px;
            height: 2px;
            background-color: #000;
            border-radius: 10px;
        }
    </style>
</head>
<body class="selection:bg-black selection:text-white">

    <nav class="sticky top-0 z-50 w-full backdrop-blur-md bg-white/70 border-b border-gray-100/50">
        <div class="max-w-3xl mx-auto px-6 py-5 flex justify-between items-center">
            
            <a href="index.php" class="text-xl font-bold tracking-tighter hover:opacity-70 transition-opacity italic">
                Kılıç
            </a>

            <div class="flex items-center gap-8 text-[13px] font-medium text-gray-400">
                <a href="index.php" class="nav-link <?php echo ($current_page == 'index.php') ? 'active-link' : ''; ?> hover:text-black">
                    Giriş
                </a>
                <a href="projeler.php" class="nav-link <?php echo ($current_page == 'projeler.php') ? 'active-link' : ''; ?> hover:text-black">
                    Projeler
                </a>
                <a href="hakkimda.php" class="nav-link <?php echo ($current_page == 'hakkimda.php') ? 'active-link' : ''; ?> hover:text-black">
                    Hikayem
                </a>
                <a href="iletisim.php" class="nav-link <?php echo ($current_page == 'iletisim.php') ? 'active-link' : ''; ?> hover:text-black">
                    İletişim
                </a>
            </div>

        </div>
    </nav>

    <div class="animate-in fade-in duration-700">