<?php 
session_start(); // 1. Oturumu başlat

// 2. Giriş kontrolü: Eğer 'admin_login' oturumu yoksa login.php'ye gönder
if (!isset($_SESSION['admin_login'])) {
    header("Location: login.php");
    exit();
}

include '../includes/db.php'; 

$baglanti = isset($conn) ? $conn : (isset($db) ? $db : null);

if (!$baglanti) {
    die("Veritabanı bağlantısı kurulamadı.");
}

$sorgu = mysqli_query($baglanti, "SELECT id FROM projects");
$proje_sayisi = ($sorgu) ? mysqli_num_rows($sorgu) : 0;
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Admin Paneli</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 font-sans">

    <nav class="bg-white shadow-sm border-b p-4">
        <div class="max-w-5xl mx-auto flex justify-between items-center">
            <h1 class="font-bold text-xl tracking-tight">Admin<span class="text-blue-600">Panel</span></h1>
            <div class="flex items-center space-x-6">
                <a href="index.php" class="text-blue-600 font-semibold">Dashboard</a>
                <a href="ekle.php" class="text-gray-600 hover:text-blue-600 transition">Proje Ekle</a>
                <a href="logout.php" class="bg-red-50 text-red-600 px-4 py-2 rounded-lg text-sm font-bold hover:bg-red-100 transition">Çıkış Yap</a>
            </div>
        </div>
    </nav>

    <main class="max-w-5xl mx-auto py-10 px-4">
        <div class="mb-8 flex justify-between items-end">
            <div>
                <h2 class="text-2xl font-bold text-gray-800">Hoş Geldin, Admin!</h2>
                <p class="text-gray-500">Siten şu an yayında ve güvenli.</p>
            </div>
            <span class="text-xs font-bold text-green-500 bg-green-50 px-3 py-1 rounded-full uppercase">Oturum Aktif</span>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="bg-white p-8 rounded-2xl shadow-sm border border-gray-200">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-400 uppercase tracking-wider">Toplam Proje</p>
                        <h3 class="text-4xl font-bold text-gray-900 mt-1"><?php echo $proje_sayisi; ?></h3>
                    </div>
                    <div class="bg-blue-50 p-4 rounded-full">
                        <svg xmlns="http://www.w3.org/2000/svg" class="h-8 w-8 text-blue-600" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                          <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10" />
                        </svg>
                    </div>
                </div>
                <a href="ekle.php" class="inline-block mt-6 text-sm font-semibold text-blue-600 hover:underline">Projeleri Yönet →</a>
            </div>

            <div class="bg-blue-600 p-8 rounded-2xl shadow-lg shadow-blue-100 text-white flex flex-col justify-between">
                <div>
                    <h3 class="text-xl font-bold">Yeni Proje Yayınla</h3>
                    <p class="text-blue-100 text-sm mt-2 leading-relaxed">Yeni bitirdiğin scriptleri buradan ekleyerek ana sayfada gösterebilirsin.</p>
                </div>
                <a href="ekle.php" class="mt-6 bg-white text-blue-600 text-center py-3 rounded-xl font-bold hover:bg-gray-100 transition">Hemen Başla</a>
            </div>
        </div>
    </main>

</body>
</html>