<?php
include 'db.php';

// Zaten giriş yapmışsa panele yolla
if(isset($_SESSION['user_id'])){
    header("Location: dashboard.php");
    exit;
}

if (isset($_POST['giris_yap'])) {
    $email = $_POST['email'];
    $sifre = $_POST['sifre'];

    $sql = $db->prepare("SELECT * FROM kullanicilar WHERE email = ?");
    $sql->execute([$email]);
    $kullanici = $sql->fetch(PDO::FETCH_ASSOC);

    if ($kullanici && password_verify($sifre, $kullanici['sifre'])) {
        
        // --- PIN KODU KONTROLÜ (BURASI ÖNEMLİ) ---
        if (!empty($kullanici['pin_kodu'])) {
            // PIN varsa geçici oturum aç ve PIN sormaya git
            $_SESSION['temp_user_id'] = $kullanici['id'];
            $_SESSION['temp_ad_soyad'] = $kullanici['ad_soyad'];
            header("Location: pin.php");
            exit;
        } else {
            // PIN yoksa direkt içeri al
            $_SESSION['user_id'] = $kullanici['id'];
            $_SESSION['ad_soyad'] = $kullanici['ad_soyad'];
            header("Location: dashboard.php");
            exit;
        }

    } else {
        $hata = "E-posta veya şifre hatalı.";
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Giriş Yap - Monify</title>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: { sans: ['"Plus Jakarta Sans"', 'sans-serif'] },
                    colors: {
                        midnight: '#0f172a',
                        sunburst: '#f59e0b',
                        sunburstHover: '#d97706',
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-slate-100 min-h-screen flex items-center justify-center p-4">

    <div class="w-full max-w-5xl bg-white rounded-3xl shadow-2xl overflow-hidden flex flex-col md:flex-row h-[600px]">
        
        <div class="hidden md:flex md:w-1/2 bg-midnight relative flex-col items-center justify-center p-12 text-center text-white overflow-hidden">
            <div class="absolute top-0 left-0 w-64 h-64 bg-sunburst/10 rounded-full blur-3xl -mt-10 -ml-10"></div>
            <div class="absolute bottom-0 right-0 w-64 h-64 bg-blue-600/20 rounded-full blur-3xl -mb-10 -mr-10"></div>
            <div class="relative z-10">
                <div class="w-20 h-20 bg-gradient-to-br from-sunburst to-amber-600 rounded-2xl flex items-center justify-center text-3xl shadow-lg mb-8 mx-auto">
                    <i class="fa-solid fa-bolt text-midnight"></i>
                </div>
                <h2 class="text-3xl font-extrabold mb-4">Paranı Yönet, <br> Geleceği Planla.</h2>
                <p class="text-slate-400 text-sm leading-relaxed max-w-xs mx-auto">Monify ile gelir ve giderlerini saniyeler içinde takip et.</p>
            </div>
            <div class="mt-auto text-xs text-slate-500">© 2025 Monify App</div>
        </div>

        <div class="w-full md:w-1/2 p-8 md:p-12 flex flex-col justify-center relative bg-white">
            <div class="max-w-sm mx-auto w-full">
                <h1 class="text-2xl font-bold text-midnight mb-2">Tekrar Hoş Geldin! 👋</h1>
                <p class="text-slate-500 text-sm mb-8">Devam etmek için giriş yap.</p>

                <?php if(isset($hata)): ?>
                    <div class="mb-6 p-4 rounded-xl bg-red-50 text-red-600 text-sm font-bold flex items-center gap-3 border border-red-100">
                        <i class="fa-solid fa-circle-exclamation"></i> <?= $hata ?>
                    </div>
                <?php endif; ?>

                <form method="POST" class="space-y-5">
                    <div>
                        <label class="block text-xs font-bold text-slate-700 uppercase mb-2">E-Posta</label>
                        <div class="relative">
                            <i class="fa-regular fa-envelope absolute left-4 top-3.5 text-slate-400"></i>
                            <input type="email" name="email" class="w-full pl-11 pr-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:bg-white focus:border-sunburst focus:ring-2 focus:ring-sunburst/20 transition-all outline-none font-semibold text-midnight" placeholder="mail@ornek.com" required>
                        </div>
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-slate-700 uppercase mb-2">Şifre</label>
                        <div class="relative">
                            <i class="fa-solid fa-lock absolute left-4 top-3.5 text-slate-400"></i>
                            <input type="password" name="sifre" class="w-full pl-11 pr-4 py-3 bg-slate-50 border border-slate-200 rounded-xl focus:bg-white focus:border-sunburst focus:ring-2 focus:ring-sunburst/20 transition-all outline-none font-semibold text-midnight" placeholder="••••••••" required>
                        </div>
                    </div>

                    <button type="submit" name="giris_yap" class="w-full bg-midnight hover:bg-slate-800 text-white font-bold py-3.5 rounded-xl shadow-lg shadow-midnight/20 transition-all transform hover:-translate-y-1 active:translate-y-0">
                        Giriş Yap
                    </button>
                </form>

                <div class="mt-8 text-center text-sm">
                    <span class="text-slate-500">Hesabın yok mu?</span>
                    <a href="register.php" class="text-sunburst font-bold hover:text-sunburstHover ml-1 transition-colors">Hemen Kayıt Ol</a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>