<?php 
include 'db.php';
include 'header.php'; 

$user_id = $_SESSION['user_id'];

// FİLTRELEME PARAMETRELERİ
$bas_tarih = $_GET['bas_tarih'] ?? '';
$bit_tarih = $_GET['bit_tarih'] ?? '';
$filtre_tur = $_GET['tur'] ?? '';
$filtre_kat = $_GET['kat'] ?? '';

// SQL Sorgusunu Dinamik Oluştur
$sql = "SELECT * FROM islemler WHERE user_id = ?";
$params = [$user_id];

if(!empty($bas_tarih)) { $sql .= " AND DATE(tarih) >= ?"; $params[] = $bas_tarih; }
if(!empty($bit_tarih)) { $sql .= " AND DATE(tarih) <= ?"; $params[] = $bit_tarih; }
if(!empty($filtre_tur)) { $sql .= " AND tur = ?"; $params[] = $filtre_tur; }
if(!empty($filtre_kat)) { $sql .= " AND kategori = ?"; $params[] = $filtre_kat; }

$sql .= " ORDER BY tarih DESC";

$sorgu = $db->prepare($sql);
$sorgu->execute($params);
$liste = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Kategorileri Çek (Dropdown için)
$katSorgu = $db->prepare("SELECT DISTINCT kategori FROM islemler WHERE user_id = ? ORDER BY kategori ASC");
$katSorgu->execute([$user_id]);
$kategoriler = $katSorgu->fetchAll(PDO::FETCH_COLUMN);
?>

<div class="max-w-6xl mx-auto">

    <div class="mb-8">
        <h1 class="text-3xl font-bold text-midnight mb-4">Hareketler</h1>
        
        <form method="GET" class="card-panel p-5 grid grid-cols-1 md:grid-cols-5 gap-4 items-end shadow-lg border-l-4 border-l-sunburst">
            <div class="md:col-span-1">
                <label class="text-xs font-bold text-slate-500 uppercase mb-1">Başlangıç</label>
                <input type="date" name="bas_tarih" value="<?= $bas_tarih ?>" class="form-input text-sm font-bold text-midnight">
            </div>
            <div class="md:col-span-1">
                <label class="text-xs font-bold text-slate-500 uppercase mb-1">Bitiş</label>
                <input type="date" name="bit_tarih" value="<?= $bit_tarih ?>" class="form-input text-sm font-bold text-midnight">
            </div>
            <div class="md:col-span-1">
                <label class="text-xs font-bold text-slate-500 uppercase mb-1">Kategori</label>
                <select name="kat" class="form-select text-sm font-bold text-midnight cursor-pointer">
                    <option value="">Tümü</option>
                    <?php foreach($kategoriler as $k): ?>
                        <option value="<?= $k ?>" <?= $filtre_kat == $k ? 'selected' : '' ?>><?= $k ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="md:col-span-1">
                <label class="text-xs font-bold text-slate-500 uppercase mb-1">Tür</label>
                <select name="tur" class="form-select text-sm font-bold text-midnight cursor-pointer">
                    <option value="">Hepsi</option>
                    <option value="gelir" <?= $filtre_tur == 'gelir' ? 'selected' : '' ?>>Gelir</option>
                    <option value="gider" <?= $filtre_tur == 'gider' ? 'selected' : '' ?>>Gider</option>
                </select>
            </div>
            <div class="md:col-span-1 flex gap-2">
                <button type="submit" class="btn-primary w-full justify-center text-sm py-2.5 shadow-md">Filtrele</button>
                <a href="liste.php" class="py-2.5 px-3 rounded-lg border border-slate-200 text-slate-500 hover:bg-slate-100 transition-colors" title="Temizle"><i class="fa-solid fa-xmark"></i></a>
            </div>
        </form>
    </div>

    <div class="card-panel p-0 overflow-hidden border-0 shadow-xl">
        <div class="overflow-x-auto">
            <table class="w-full text-left border-collapse">
                <thead>
                    <tr class="bg-slate-50 border-b border-slate-100 text-xs uppercase tracking-wider text-slate-500 font-bold">
                        <th class="p-5">Açıklama</th>
                        <th class="p-5">Kategori</th>
                        <th class="p-5">Tarih</th>
                        <th class="p-5 text-right">Tutar</th>
                        <th class="p-5 text-center">İşlem</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-slate-50">
                    <?php foreach($liste as $row): 
                        $isGelir = ($row['tur'] == 'gelir');
                        $renk = $isGelir ? 'text-emerald-600' : 'text-red-600';
                        $bgRenk = $isGelir ? 'bg-emerald-50' : 'bg-red-50';
                        $ikon = $isGelir ? 'fa-arrow-up' : 'fa-arrow-down';
                    ?>
                    <tr class="hover:bg-yellow-50/50 transition-colors group">
                        <td class="p-5">
                            <div class="flex items-center gap-4">
                                <div class="w-10 h-10 rounded-xl <?= $bgRenk ?> <?= $renk ?> flex items-center justify-center text-lg shadow-sm">
                                    <i class="fa-solid <?= $ikon ?>"></i>
                                </div>
                                <div>
                                    <div class="font-bold text-midnight text-sm"><?= htmlspecialchars($row['aciklama']) ?></div>
                                    <div class="text-xs text-slate-400 font-medium uppercase"><?= $row['tur'] ?></div>
                                </div>
                            </div>
                        </td>
                        <td class="p-5">
                            <span class="inline-flex items-center gap-1.5 px-3 py-1 rounded-full text-xs font-bold bg-slate-100 text-slate-600 border border-slate-200">
                                <?= htmlspecialchars($row['kategori']) ?>
                            </span>
                        </td>
                        <td class="p-5">
                            <div class="text-sm font-semibold text-slate-600 flex items-center gap-2">
                                <i class="fa-regular fa-calendar text-slate-400"></i>
                                <?= date("d.m.Y", strtotime($row['tarih'])) ?>
                            </div>
                        </td>
                        <td class="p-5 text-right">
                            <span class="font-semibold text-sm font-mono tracking-tight <?= $renk ?>">
                                <?= $isGelir ? '+' : '-' ?><?= number_format($row['miktar'], 2) ?> ₺
                            </span>
                        </td>
                        <td class="p-5 text-center">
                            <div class="inline-flex gap-2 opacity-100 md:opacity-0 group-hover:opacity-100 transition-opacity">
                                <a href="duzenle.php?id=<?= $row['id'] ?>" class="w-8 h-8 flex items-center justify-center rounded-lg bg-amber-100 text-amber-600 hover:bg-amber-500 hover:text-white transition-all shadow-sm"><i class="fa-solid fa-pen text-xs"></i></a>
                                <a href="islem.php?sil=<?= $row['id'] ?>" onclick="return confirm('Silmek istiyor musun?')" class="w-8 h-8 flex items-center justify-center rounded-lg bg-red-100 text-red-600 hover:bg-red-500 hover:text-white transition-all shadow-sm"><i class="fa-solid fa-trash text-xs"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            
            <?php if(empty($liste)): ?>
            <div class="py-16 text-center">
                <div class="w-20 h-20 bg-slate-50 rounded-full flex items-center justify-center mx-auto mb-4 text-slate-300">
                    <i class="fa-solid fa-filter-circle-xmark text-3xl"></i>
                </div>
                <h3 class="text-xl font-bold text-midnight mb-1">Sonuç Bulunamadı</h3>
                <p class="text-slate-500 text-sm">Seçtiğin kriterlere uygun işlem yok.</p>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<div style="height: 50px;"></div>
</body>
</html>