<?php 
include 'db.php';

if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit; }
$user_id = $_SESSION['user_id'];

// --- İŞLEMLER ---

// 1. HEDEF EKLEME
if (isset($_POST['hedef_ekle'])) {
    $kategori = $_POST['kategori'];
    $tutar = $_POST['hedef_tutar'];
    
    // Aynı kategoriye daha önce hedef konmuş mu?
    $kontrol = $db->prepare("SELECT id FROM butce_hedefleri WHERE user_id = ? AND kategori = ?");
    $kontrol->execute([$user_id, $kategori]);
    
    if($kontrol->rowCount() > 0) {
        $hata = "Bu kategori için zaten bir hedef var.";
    } else {
        $db->prepare("INSERT INTO butce_hedefleri (user_id, kategori, hedef_tutar) VALUES (?, ?, ?)")->execute([$user_id, $kategori, $tutar]);
        header("Location: butceler.php?durum=ok"); exit;
    }
}

// 2. HEDEF GÜNCELLEME
if (isset($_POST['hedef_guncelle'])) {
    $id = $_POST['edit_id'];
    $tutar = $_POST['edit_tutar'];
    
    if($tutar > 0) {
        $db->prepare("UPDATE butce_hedefleri SET hedef_tutar = ? WHERE id = ? AND user_id = ?")->execute([$tutar, $id, $user_id]);
        header("Location: butceler.php?durum=guncellendi"); exit;
    }
}

// 3. SİLME
if (isset($_GET['sil'])) {
    $db->prepare("DELETE FROM butce_hedefleri WHERE id = ? AND user_id = ?")->execute([$_GET['sil'], $user_id]);
    header("Location: butceler.php?durum=silindi"); exit;
}

include 'header.php'; 

// Gider Kategorilerini Çek (Dropdown İçin)
$katSorgu = $db->prepare("SELECT * FROM kategoriler WHERE user_id = ? AND tur = 'gider' ORDER BY ad ASC");
$katSorgu->execute([$user_id]);
$giderKategorileri = $katSorgu->fetchAll(PDO::FETCH_ASSOC);

// Hedefleri ve O Kategorideki Bu Ayın Harcamasını Çek
$sql = "
    SELECT 
        b.id, b.kategori, b.hedef_tutar,
        COALESCE(SUM(i.miktar), 0) as harcanan
    FROM butce_hedefleri b
    LEFT JOIN islemler i ON b.kategori = i.kategori 
        AND i.user_id = b.user_id 
        AND i.tur = 'gider'
        AND MONTH(i.tarih) = MONTH(CURRENT_DATE()) 
        AND YEAR(i.tarih) = YEAR(CURRENT_DATE())
    WHERE b.user_id = ?
    GROUP BY b.id
    ORDER BY b.hedef_tutar DESC
";
$sorgu = $db->prepare($sql);
$sorgu->execute([$user_id]);
$hedefler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Genel Özet Hesaplama
$toplamLimit = 0;
$toplamHarcanan = 0;
foreach($hedefler as $h) {
    $toplamLimit += $h['hedef_tutar'];
    $toplamHarcanan += $h['harcanan'];
}
$genelYuzde = ($toplamLimit > 0) ? ($toplamHarcanan / $toplamLimit) * 100 : 0;
?>

<div class="max-w-6xl mx-auto">
    
    <div class="mb-8 flex flex-col md:flex-row justify-between items-end gap-4">
        <div>
            <h1 class="text-3xl font-bold text-midnight mb-2">Bütçe Hedefleri</h1>
            <p class="text-slate-500 font-medium">Harcamalarını kontrol altında tut, limitlerini aşma.</p>
        </div>
        <button onclick="modalAc('eklemeModal')" class="bg-midnight hover:bg-slate-800 text-white px-6 py-3 rounded-xl shadow-lg shadow-midnight/30 font-bold transition-all transform hover:-translate-y-1 flex items-center gap-2">
            <i class="fa-solid fa-bullseye text-sunburst"></i> Yeni Hedef
        </button>
    </div>

    <?php if(isset($hata)): ?>
        <div class="mb-6 p-4 rounded-xl bg-red-50 text-red-700 border border-red-100 flex items-center gap-3 font-bold shadow-sm animate-pulse">
            <i class="fa-solid fa-circle-exclamation text-xl"></i> <?= $hata ?>
        </div>
    <?php endif; ?>

    <?php if(!empty($hedefler)): ?>
    <div class="card-panel p-8 mb-8 border-t-4 border-t-sunburst relative overflow-hidden">
        <div class="flex justify-between items-end mb-4 relative z-10">
            <div>
                <h3 class="text-lg font-bold text-midnight mb-1">Genel Bütçe Durumu</h3>
                <p class="text-slate-500 text-sm">Bu ayki toplam limitlerin ve harcaman.</p>
            </div>
            <div class="text-right">
                <div class="text-3xl font-extrabold text-midnight"><?= round($genelYuzde) ?>%</div>
                <div class="text-xs font-bold text-slate-400 uppercase tracking-wider">DOLULUK</div>
            </div>
        </div>
        
        <div class="w-full bg-slate-100 rounded-full h-6 mb-4 overflow-hidden shadow-inner relative z-10">
            <div class="h-full bg-gradient-to-r from-sunburst to-amber-600 rounded-full transition-all duration-1000 ease-out shadow-lg relative" style="width: 0%" id="genelBar">
                <div class="absolute top-0 left-0 w-full h-full bg-white/20" style="background-image: linear-gradient(45deg,rgba(255,255,255,.15) 25%,transparent 25%,transparent 50%,rgba(255,255,255,.15) 50%,rgba(255,255,255,.15) 75%,transparent 75%,transparent); background-size: 1rem 1rem;"></div>
            </div>
        </div>
        <script>setTimeout(() => { document.getElementById('genelBar').style.width = '<?= min($genelYuzde, 100) ?>%'; }, 300);</script>

        <div class="flex justify-between text-sm font-bold relative z-10">
            <div class="text-slate-500">Harcanan: <span class="text-midnight"><?= number_format($toplamHarcanan, 0) ?> ₺</span></div>
            <div class="text-slate-500">Toplam Limit: <span class="text-midnight"><?= number_format($toplamLimit, 0) ?> ₺</span></div>
        </div>

        <div class="absolute top-0 right-0 w-40 h-40 bg-sunburst/5 rounded-full blur-3xl -mr-10 -mt-10 pointer-events-none"></div>
    </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php if(empty($hedefler)): ?>
            <div class="col-span-full card-panel text-center py-16 border-dashed border-2 border-slate-200 shadow-none">
                <div class="w-20 h-20 bg-slate-50 rounded-full flex items-center justify-center mx-auto mb-4 text-slate-300 text-4xl"><i class="fa-solid fa-bullseye"></i></div>
                <h3 class="text-xl font-bold text-midnight">Hedef Yok</h3>
                <p class="text-slate-500 mt-2">Paranın nereye gittiğini kontrol etmek için bir limit koy.</p>
                <button onclick="modalAc('eklemeModal')" class="mt-6 text-sunburst font-bold hover:underline">İlk Hedefi Ekle</button>
            </div>
        <?php else: ?>
            <?php foreach($hedefler as $h): 
                $yuzde = ($h['hedef_tutar'] > 0) ? ($h['harcanan'] / $h['hedef_tutar']) * 100 : 0;
                $yuzdeGosterim = min($yuzde, 100); 
                $kalan = $h['hedef_tutar'] - $h['harcanan'];
                
                // Renk ve Durum Belirleme
                $durumMetni = "İyi Gidiyorsun";
                $renk = "bg-emerald-500"; $text = "text-emerald-600"; $bgIcon = "bg-emerald-50 text-emerald-600"; $border = "border-emerald-100";
                
                if($yuzde >= 50) { 
                    $durumMetni = "Dikkat Et";
                    $renk = "bg-amber-500"; $text = "text-amber-600"; $bgIcon = "bg-amber-50 text-amber-600"; $border = "border-amber-100";
                }
                if($yuzde >= 80) {
                    $durumMetni = "Sınırdasın!";
                    $renk = "bg-orange-500"; $text = "text-orange-600"; $bgIcon = "bg-orange-50 text-orange-600"; $border = "border-orange-100";
                }
                if($yuzde >= 100) { 
                    $durumMetni = "LİMİT AŞILDI!";
                    $renk = "bg-red-500"; $text = "text-red-600"; $bgIcon = "bg-red-50 text-red-600"; $border = "border-red-100";
                }
            ?>
            <div class="bg-white rounded-2xl p-6 border <?= $border ?> shadow-lg hover:shadow-xl transition-all relative overflow-hidden group">
                
                <div class="flex justify-between items-start mb-4">
                    <div class="flex items-center gap-3">
                        <div class="w-10 h-10 rounded-xl <?= $bgIcon ?> flex items-center justify-center text-lg shadow-sm">
                            <i class="fa-solid fa-chart-pie"></i>
                        </div>
                        <div>
                            <h4 class="font-bold text-midnight text-lg truncate w-32"><?= htmlspecialchars($h['kategori']) ?></h4>
                            <div class="text-[10px] font-bold <?= $text ?> uppercase tracking-wider"><?= $durumMetni ?></div>
                        </div>
                    </div>
                    
                    <div class="flex gap-1 opacity-0 group-hover:opacity-100 transition-opacity absolute top-4 right-4 bg-white shadow-sm p-1 rounded-lg">
                        <button onclick="duzenleModalAc(<?= $h['id'] ?>, '<?= htmlspecialchars($h['kategori']) ?>', <?= $h['hedef_tutar'] ?>)" class="w-7 h-7 flex items-center justify-center rounded text-slate-400 hover:text-blue-600 hover:bg-blue-50"><i class="fa-solid fa-pen text-xs"></i></button>
                        <a href="?sil=<?= $h['id'] ?>" onclick="return confirm('Bu hedefi silmek istiyor musun?')" class="w-7 h-7 flex items-center justify-center rounded text-slate-400 hover:text-red-600 hover:bg-red-50"><i class="fa-solid fa-trash-can text-xs"></i></a>
                    </div>
                </div>

                <div class="flex items-baseline justify-between mb-2">
                    <div class="text-sm font-bold text-slate-500">Harcama</div>
                    <div class="text-lg font-bold text-midnight"><?= number_format($h['harcanan'], 0) ?> <span class="text-xs text-slate-400">/ <?= number_format($h['hedef_tutar'], 0) ?></span></div>
                </div>

                <div class="w-full bg-slate-100 rounded-full h-2.5 mb-3 overflow-hidden">
                    <div class="h-full <?= $renk ?> rounded-full shadow-sm transition-all duration-1000 ease-out relative" style="width: 0%" id="bar-<?= $h['id'] ?>">
                        <?php if($yuzde >= 100): ?>
                            <div class="absolute inset-0 bg-white/30 animate-pulse"></div>
                        <?php endif; ?>
                    </div>
                </div>
                <script>setTimeout(() => { document.getElementById('bar-<?= $h['id'] ?>').style.width = '<?= $yuzdeGosterim ?>%'; }, 300);</script>

                <div class="text-right">
                    <?php if($kalan >= 0): ?>
                        <span class="text-xs font-bold text-emerald-600 bg-emerald-50 px-2 py-1 rounded">Kalan: <?= number_format($kalan, 0) ?> ₺</span>
                    <?php else: ?>
                        <span class="text-xs font-bold text-red-600 bg-red-50 px-2 py-1 rounded">Aşılan: <?= number_format(abs($kalan), 0) ?> ₺</span>
                    <?php endif; ?>
                </div>
            </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<div id="eklemeModal" class="hidden fixed inset-0 z-50 flex items-center justify-center bg-midnight/80 backdrop-blur-sm px-4">
    <div class="bg-white rounded-2xl p-6 w-full max-w-md shadow-2xl relative transform scale-100 transition-all">
        <h3 class="text-xl font-bold text-midnight mb-6 flex items-center gap-2"><i class="fa-solid fa-bullseye text-sunburst"></i> Yeni Hedef</h3>
        <form method="POST">
            <div class="mb-5">
                <label class="form-label text-xs uppercase text-slate-500">Kategori Seç</label>
                <div class="relative">
                    <i class="fa-solid fa-tag absolute left-3 top-3.5 text-slate-400 text-sm"></i>
                    <select name="kategori" class="form-select pl-10 font-bold cursor-pointer">
                        <?php foreach($giderKategorileri as $k): ?>
                            <option value="<?= htmlspecialchars($k['ad']) ?>"><?= htmlspecialchars($k['ad']) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <p class="text-xs text-slate-400 mt-2 ml-1">Sadece gider kategorilerine hedef koyabilirsin.</p>
            </div>
            <div class="mb-8">
                <label class="form-label text-xs uppercase text-slate-500">Aylık Limit Tutarı</label>
                <div class="relative"><span class="absolute left-3 top-3.5 text-slate-500 font-bold text-lg">₺</span><input type="number" name="hedef_tutar" class="form-input pl-8 font-bold text-lg" placeholder="0.00" step="0.01" required></div>
            </div>
            <div class="grid grid-cols-2 gap-3"><button type="button" onclick="modalKapat('eklemeModal')" class="btn-primary bg-slate-200 text-slate-600 hover:bg-slate-300 shadow-none justify-center">İptal</button><button type="submit" name="hedef_ekle" class="btn-primary justify-center shadow-lg shadow-amber-500/20">Hedef Koy</button></div>
        </form>
    </div>
</div>

<div id="duzenlemeModal" class="hidden fixed inset-0 z-50 flex items-center justify-center bg-midnight/80 backdrop-blur-sm px-4">
    <div class="bg-white rounded-2xl p-6 w-full max-w-md shadow-2xl relative transform scale-100 transition-all">
        <h3 class="text-xl font-bold text-midnight mb-2 flex items-center gap-2"><i class="fa-solid fa-pen text-blue-600"></i> Hedefi Düzenle</h3>
        <p class="text-sm text-slate-500 mb-6 font-bold" id="edit_kategori_adi">Kategori Adı</p>
        <form method="POST">
            <input type="hidden" name="edit_id" id="edit_id">
            <div class="mb-8">
                <label class="form-label text-xs uppercase text-slate-500">Yeni Limit</label>
                <div class="relative"><span class="absolute left-3 top-3.5 text-slate-500 font-bold text-lg">₺</span><input type="number" name="edit_tutar" id="edit_tutar" class="form-input pl-8 font-bold text-lg" step="0.01" required></div>
            </div>
            <div class="grid grid-cols-2 gap-3"><button type="button" onclick="modalKapat('duzenlemeModal')" class="btn-primary bg-slate-200 text-slate-600 hover:bg-slate-300 shadow-none justify-center">İptal</button><button type="submit" name="hedef_guncelle" class="btn-primary bg-blue-600 hover:bg-blue-700 text-white justify-center shadow-lg">Güncelle</button></div>
        </form>
    </div>
</div>

<script>
    function modalAc(id) { document.getElementById(id).classList.remove('hidden'); }
    function modalKapat(id) { document.getElementById(id).classList.add('hidden'); }
    
    function duzenleModalAc(id, kategori, tutar) {
        document.getElementById('edit_id').value = id;
        document.getElementById('edit_kategori_adi').innerText = kategori;
        document.getElementById('edit_tutar').value = tutar;
        modalAc('duzenlemeModal');
    }
    window.onclick = function(event) { if (event.target.classList.contains('fixed')) event.target.classList.add('hidden'); }
</script>

<div class="h-12"></div>
</body>
</html>