<?php 
include 'db.php';

// Oturum kontrolü
if (!isset($_SESSION['user_id'])) { header("Location: login.php"); exit; }
$user_id = $_SESSION['user_id'];

// --- İŞLEMLER ---

// 1. EKLEME
if (isset($_POST['abone_ekle'])) {
    $baslik = trim($_POST['baslik']);
    $miktar = $_POST['miktar'];
    $tur = $_POST['tur'];
    $kategori = $_POST['kategori'];
    $periyot = $_POST['periyot'];
    $baslangic = $_POST['baslangic_tarihi'];
    
    if(!empty($baslik) && !empty($miktar) && !empty($baslangic)) {
        $db->prepare("INSERT INTO abonelikler (user_id, baslik, miktar, tur, kategori, periyot, baslangic_tarihi, sonraki_tarih) VALUES (?, ?, ?, ?, ?, ?, ?, ?)")
           ->execute([$user_id, $baslik, $miktar, $tur, $kategori, $periyot, $baslangic, $baslangic]);
        header("Location: abonelikler.php?durum=ok"); exit;
    }
}

// 2. SİLME
if (isset($_GET['sil'])) {
    $db->prepare("DELETE FROM abonelikler WHERE id = ? AND user_id = ?")->execute([$_GET['sil'], $user_id]);
    header("Location: abonelikler.php?durum=silindi"); exit;
}

// 3. DÜZENLEME (YENİ)
if (isset($_POST['abone_guncelle'])) {
    $id = $_POST['edit_id'];
    $baslik = trim($_POST['edit_baslik']);
    $miktar = $_POST['edit_miktar'];
    $tur = $_POST['edit_tur'];
    $kategori = $_POST['edit_kategori'];
    $periyot = $_POST['edit_periyot'];
    $baslangic = $_POST['edit_baslangic'];
    
    // Sonraki tarihi güncellemek istersen mantık kurabilirsin, şimdilik sadece bilgileri güncelliyoruz
    // Eğer başlangıç tarihi değişirse sonraki tarihi de sıfırlamak mantıklı olabilir, ama basit tutalım.
    
    if(!empty($baslik)) {
        $sql = "UPDATE abonelikler SET baslik=?, miktar=?, tur=?, kategori=?, periyot=?, baslangic_tarihi=? WHERE id=? AND user_id=?";
        $db->prepare($sql)->execute([$baslik, $miktar, $tur, $kategori, $periyot, $baslangic, $id, $user_id]);
        header("Location: abonelikler.php?durum=guncellendi"); exit;
    }
}

include 'header.php'; 

// Verileri Çek
$sorgu = $db->prepare("SELECT * FROM abonelikler WHERE user_id = ? ORDER BY sonraki_tarih ASC");
$sorgu->execute([$user_id]);
$abonelikler = $sorgu->fetchAll(PDO::FETCH_ASSOC);

// Kategorileri Çek
$katSorgu = $db->prepare("SELECT * FROM kategoriler WHERE user_id = ? ORDER BY ad ASC");
$katSorgu->execute([$user_id]);
$dbKategoriler = $katSorgu->fetchAll(PDO::FETCH_ASSOC);

$jsGiderler = []; $jsGelirler = [];
foreach($dbKategoriler as $k) {
    if($k['tur'] == 'gider') $jsGiderler[] = $k['ad']; else $jsGelirler[] = $k['ad'];
}
?>

<div class="max-w-6xl mx-auto">
    
    <div class="mb-8 flex flex-col md:flex-row justify-between items-end gap-4">
        <div>
            <h1 class="text-3xl font-bold text-midnight mb-2">Otomatik İşlemler</h1>
            <p class="text-slate-500 font-medium">Düzenli ödemelerini buradan yönet.</p>
        </div>
        <button onclick="modalAc('eklemeModal')" class="bg-midnight hover:bg-slate-800 text-white px-6 py-3 rounded-xl shadow-lg shadow-midnight/30 font-bold transition-all transform hover:-translate-y-1 flex items-center gap-2">
            <i class="fa-solid fa-plus"></i> Yeni Talimat
        </button>
    </div>

    <?php if(isset($_GET['durum'])): ?>
        <div class="mb-6 p-4 rounded-xl border flex items-center gap-3 shadow-sm font-bold 
            <?= ($_GET['durum']=='silindi') ? 'bg-red-50 text-red-700 border-red-100' : 'bg-emerald-50 text-emerald-700 border-emerald-100' ?>">
            <i class="fa-solid <?= ($_GET['durum']=='silindi') ? 'fa-trash' : 'fa-check-circle' ?> text-xl"></i>
            <span>
                <?php 
                    if($_GET['durum']=='ok') echo 'Yeni talimat oluşturuldu.';
                    elseif($_GET['durum']=='guncellendi') echo 'Talimat güncellendi.';
                    else echo 'Talimat iptal edildi.';
                ?>
            </span>
        </div>
    <?php endif; ?>

    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <?php if(empty($abonelikler)): ?>
            <div class="col-span-full card-panel text-center py-16 border-dashed border-2 border-slate-200 shadow-none">
                <div class="w-20 h-20 bg-slate-50 rounded-full flex items-center justify-center mx-auto mb-4 text-slate-300 text-4xl"><i class="fa-solid fa-calendar-xmark"></i></div>
                <h3 class="text-xl font-bold text-midnight">Aktif Talimat Yok</h3>
                <p class="text-slate-500 mt-2">Netflix, Kira veya Harçlık gibi düzenli işlemlerini ekle.</p>
                <button onclick="modalAc('eklemeModal')" class="mt-6 text-sunburst font-bold hover:underline">İlk Talimatı Ekle</button>
            </div>
        <?php else: ?>
            <?php foreach($abonelikler as $abone): 
                $isGelir = ($abone['tur'] == 'gelir');
                $renk = $isGelir ? 'text-emerald-600' : 'text-red-600';
                $bgIcon = $isGelir ? 'bg-emerald-50 border-emerald-100' : 'bg-red-50 border-red-100';
                $ikon = $isGelir ? 'fa-arrow-trend-up' : 'fa-arrow-trend-down';
                $kalanGun = (strtotime($abone['sonraki_tarih']) - time()) / (60 * 60 * 24);
                $kalanGun = ceil($kalanGun);
                
                $periyotEtiketi = "Her Ay";
                $periyotClass = "bg-blue-50 text-blue-700 border-blue-100";
                if($abone['periyot'] == 'gunluk') { $periyotEtiketi = "Her Gün"; $periyotClass = "bg-purple-50 text-purple-700 border-purple-100"; }
                elseif($abone['periyot'] == 'haftalik') { $periyotEtiketi = "Her Hafta"; $periyotClass = "bg-amber-50 text-amber-700 border-amber-100"; }
                elseif($abone['periyot'] == 'yillik') { $periyotEtiketi = "Her Yıl"; $periyotClass = "bg-indigo-50 text-indigo-700 border-indigo-100"; }
            ?>
            <div class="bg-white rounded-2xl p-6 border border-slate-100 shadow-lg hover:shadow-xl transition-all relative group">
                <div class="absolute top-4 right-4 flex gap-2 opacity-0 group-hover:opacity-100 transition-opacity">
                    <button onclick="duzenleModalAc(<?= htmlspecialchars(json_encode($abone)) ?>)" class="w-8 h-8 rounded-lg bg-blue-50 text-blue-600 hover:bg-blue-600 hover:text-white flex items-center justify-center transition-colors"><i class="fa-solid fa-pen text-xs"></i></button>
                    <a href="?sil=<?= $abone['id'] ?>" onclick="return confirm('İptal etmek istiyor musun?')" class="w-8 h-8 rounded-lg bg-red-50 text-red-600 hover:bg-red-600 hover:text-white flex items-center justify-center transition-colors"><i class="fa-solid fa-trash-can text-xs"></i></a>
                </div>

                <div class="flex items-center gap-4 mb-5">
                    <div class="w-12 h-12 rounded-xl <?= $bgIcon ?> flex items-center justify-center <?= $renk ?> border shadow-sm text-xl">
                        <i class="fa-solid <?= $ikon ?>"></i>
                    </div>
                    <div>
                        <h4 class="font-bold text-midnight text-lg truncate w-40"><?= htmlspecialchars($abone['baslik']) ?></h4>
                        <div class="flex gap-2 items-center mt-1">
                            <span class="text-[10px] font-bold px-2 py-0.5 rounded-md border <?= $periyotClass ?>"><?= $periyotEtiketi ?></span>
                            <span class="text-xs text-slate-400 font-medium"><?= htmlspecialchars($abone['kategori']) ?></span>
                        </div>
                    </div>
                </div>

                <div class="flex justify-between items-end border-t border-slate-100 pt-4">
                    <div>
                        <div class="text-[10px] text-slate-400 font-bold uppercase tracking-wider mb-1">SONRAKİ ÖDEME</div>
                        <div class="flex items-center gap-2">
                            <i class="fa-regular fa-clock text-slate-400"></i>
                            <span class="font-bold text-slate-700 text-sm"><?= date("d.m.Y", strtotime($abone['sonraki_tarih'])) ?></span>
                            <?php if($kalanGun <= 3 && $kalanGun >= 0): ?>
                                <span class="w-2 h-2 rounded-full bg-red-500 animate-pulse"></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="text-xl font-mono font-bold <?= $renk ?>">
                        <?= number_format($abone['miktar'], 2) ?> ₺
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
</div>

<div id="eklemeModal" class="hidden fixed inset-0 z-50 flex items-center justify-center bg-midnight/80 backdrop-blur-sm px-4">
    <div class="bg-white rounded-2xl p-6 w-full max-w-md shadow-2xl relative transform scale-100 transition-all max-h-[90vh] overflow-y-auto">
        <h3 class="text-xl font-bold text-midnight mb-6 flex items-center gap-2"><i class="fa-solid fa-clock-rotate-left text-sunburst"></i> Yeni Talimat</h3>
        
        <form method="POST">
            <div class="mb-4">
                <label class="form-label text-xs uppercase text-slate-500">Başlık</label>
                <input type="text" name="baslik" class="form-input font-bold" placeholder="Örn: Netflix" required>
            </div>
            <div class="mb-4">
                <label class="form-label text-xs uppercase text-slate-500">Tutar</label>
                <div class="relative">
                    <span class="absolute left-3 top-3.5 text-slate-500 font-bold text-lg">₺</span>
                    <input type="number" name="miktar" class="form-input pl-8 font-bold" placeholder="0.00" step="0.01" required>
                </div>
            </div>
            <div class="grid grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="form-label text-xs uppercase text-slate-500">Sıklık</label>
                    <select name="periyot" class="form-select font-bold text-midnight cursor-pointer">
                        <option value="aylik">Her Ay</option>
                        <option value="haftalik">Her Hafta</option>
                        <option value="gunluk">Her Gün</option>
                        <option value="yillik">Her Yıl</option>
                    </select>
                </div>
                <div>
                    <label class="form-label text-xs uppercase text-slate-500">Başlangıç</label>
                    <input type="date" name="baslangic_tarihi" class="form-input font-bold text-sm" required value="<?= date('Y-m-d') ?>">
                </div>
            </div>
            <div class="mb-4">
                <label class="form-label text-xs uppercase text-slate-500">Tür</label>
                <div class="grid grid-cols-2 gap-3">
                    <label class="cursor-pointer"><input type="radio" name="tur" value="gider" class="peer sr-only" checked onchange="turDegisti('gider', 'kategoriSecimi')"><div class="text-center py-2.5 rounded-xl border border-slate-200 text-slate-500 peer-checked:bg-red-50 peer-checked:text-red-600 peer-checked:border-red-200 font-bold text-sm hover:bg-slate-50"><i class="fa-solid fa-arrow-down mr-1"></i> Gider</div></label>
                    <label class="cursor-pointer"><input type="radio" name="tur" value="gelir" class="peer sr-only" onchange="turDegisti('gelir', 'kategoriSecimi')"><div class="text-center py-2.5 rounded-xl border border-slate-200 text-slate-500 peer-checked:bg-emerald-50 peer-checked:text-emerald-600 peer-checked:border-emerald-200 font-bold text-sm hover:bg-slate-50"><i class="fa-solid fa-arrow-up mr-1"></i> Gelir</div></label>
                </div>
            </div>
            <div class="mb-6">
                <label class="form-label text-xs uppercase text-slate-500">Kategori</label>
                <select name="kategori" id="kategoriSecimi" class="form-select font-bold cursor-pointer"></select>
            </div>
            <div class="grid grid-cols-2 gap-3">
                <button type="button" onclick="modalKapat('eklemeModal')" class="btn-primary bg-slate-200 text-slate-600 hover:bg-slate-300 shadow-none justify-center">İptal</button>
                <button type="submit" name="abone_ekle" class="btn-primary justify-center shadow-lg shadow-amber-500/20">Oluştur</button>
            </div>
        </form>
    </div>
</div>

<div id="duzenlemeModal" class="hidden fixed inset-0 z-50 flex items-center justify-center bg-midnight/80 backdrop-blur-sm px-4">
    <div class="bg-white rounded-2xl p-6 w-full max-w-md shadow-2xl relative transform scale-100 transition-all max-h-[90vh] overflow-y-auto">
        <h3 class="text-xl font-bold text-midnight mb-6 flex items-center gap-2"><i class="fa-solid fa-pen text-blue-600"></i> Düzenle</h3>
        
        <form method="POST">
            <input type="hidden" name="edit_id" id="edit_id">
            
            <div class="mb-4">
                <label class="form-label text-xs uppercase text-slate-500">Başlık</label>
                <input type="text" name="edit_baslik" id="edit_baslik" class="form-input font-bold" required>
            </div>
            <div class="mb-4">
                <label class="form-label text-xs uppercase text-slate-500">Tutar</label>
                <div class="relative">
                    <span class="absolute left-3 top-3.5 text-slate-500 font-bold text-lg">₺</span>
                    <input type="number" name="edit_miktar" id="edit_miktar" class="form-input pl-8 font-bold" step="0.01" required>
                </div>
            </div>
            <div class="grid grid-cols-2 gap-4 mb-4">
                <div>
                    <label class="form-label text-xs uppercase text-slate-500">Sıklık</label>
                    <select name="edit_periyot" id="edit_periyot" class="form-select font-bold text-midnight cursor-pointer">
                        <option value="aylik">Her Ay</option>
                        <option value="haftalik">Her Hafta</option>
                        <option value="gunluk">Her Gün</option>
                        <option value="yillik">Her Yıl</option>
                    </select>
                </div>
                <div>
                    <label class="form-label text-xs uppercase text-slate-500">Başlangıç</label>
                    <input type="date" name="edit_baslangic" id="edit_baslangic" class="form-input font-bold text-sm" required>
                </div>
            </div>
            <div class="mb-4">
                <label class="form-label text-xs uppercase text-slate-500">Tür</label>
                <div class="grid grid-cols-2 gap-3">
                    <label class="cursor-pointer"><input type="radio" name="edit_tur" value="gider" id="edit_tur_gider" class="peer sr-only" onchange="turDegisti('gider', 'edit_kategori')"><div class="text-center py-2.5 rounded-xl border border-slate-200 text-slate-500 peer-checked:bg-red-50 peer-checked:text-red-600 peer-checked:border-red-200 font-bold text-sm hover:bg-slate-50">Gider</div></label>
                    <label class="cursor-pointer"><input type="radio" name="edit_tur" value="gelir" id="edit_tur_gelir" class="peer sr-only" onchange="turDegisti('gelir', 'edit_kategori')"><div class="text-center py-2.5 rounded-xl border border-slate-200 text-slate-500 peer-checked:bg-emerald-50 peer-checked:text-emerald-600 peer-checked:border-emerald-200 font-bold text-sm hover:bg-slate-50">Gelir</div></label>
                </div>
            </div>
            <div class="mb-6">
                <label class="form-label text-xs uppercase text-slate-500">Kategori</label>
                <select name="edit_kategori" id="edit_kategori" class="form-select font-bold cursor-pointer"></select>
            </div>
            <div class="grid grid-cols-2 gap-3">
                <button type="button" onclick="modalKapat('duzenlemeModal')" class="btn-primary bg-slate-200 text-slate-600 hover:bg-slate-300 shadow-none justify-center">İptal</button>
                <button type="submit" name="abone_guncelle" class="btn-primary bg-midnight text-white hover:bg-slate-800 justify-center">Güncelle</button>
            </div>
        </form>
    </div>
</div>

<script>
    const giderKategorileri = <?= json_encode($jsGiderler) ?>;
    const gelirKategorileri = <?= json_encode($jsGelirler) ?>;

    function turDegisti(tur, targetId) {
        const select = document.getElementById(targetId);
        const liste = (tur === 'gider') ? giderKategorileri : gelirKategorileri;
        select.innerHTML = "";
        if(liste.length === 0) {
            const opt = document.createElement("option"); opt.text = "Kategori Yok"; select.appendChild(opt);
        } else {
            liste.forEach(kat => {
                const opt = document.createElement("option"); opt.value = kat; opt.text = kat; select.appendChild(opt);
            });
        }
    }

    function modalAc(id) { document.getElementById(id).classList.remove('hidden'); }
    function modalKapat(id) { document.getElementById(id).classList.add('hidden'); }

    function duzenleModalAc(data) {
        // Formu doldur
        document.getElementById('edit_id').value = data.id;
        document.getElementById('edit_baslik').value = data.baslik;
        document.getElementById('edit_miktar').value = data.miktar;
        document.getElementById('edit_periyot').value = data.periyot;
        document.getElementById('edit_baslangic').value = data.baslangic_tarihi;
        
        // Türü seç ve kategorileri güncelle
        if(data.tur === 'gider') document.getElementById('edit_tur_gider').checked = true;
        else document.getElementById('edit_tur_gelir').checked = true;
        
        turDegisti(data.tur, 'edit_kategori');
        
        // Kategoriyi seç
        document.getElementById('edit_kategori').value = data.kategori;
        
        modalAc('duzenlemeModal');
    }

    window.onload = () => {
        turDegisti('gider', 'kategoriSecimi');
    };
    
    // Dışarı tıklayınca kapatma
    window.onclick = function(event) {
        if (event.target.classList.contains('fixed')) {
            event.target.classList.add('hidden');
        }
    }
</script>

<div class="h-12"></div>
</body>
</html>